# Installation & Schnellstart

## Schritt 1: Plugin installieren

### Option A: Manueller Upload
1. Laden Sie das gesamte `wp-ga4-sst` Verzeichnis hoch
2. Verschieben Sie es nach `/wp-content/plugins/wp-ga4-sst/`
3. Gehen Sie in WordPress zu **Plugins**
4. Aktivieren Sie "WP GA4 Server-Side Tracking"

### Option B: Via Git
```bash
cd /path/to/wordpress/wp-content/plugins/
git clone https://github.com/yourusername/wp-ga4-sst.git
```
Dann in WordPress das Plugin aktivieren.

## Schritt 2: Google Analytics 4 konfigurieren

1. Öffnen Sie [Google Analytics](https://analytics.google.com/)
2. Gehen Sie zu **Admin** (Zahnrad unten links)
3. Wählen Sie Ihre Property aus
4. Klicken Sie auf **Datenströme**
5. Wählen Sie Ihren **Web-Datenstrom** aus

### Measurement ID kopieren
- Kopieren Sie die **Measurement ID** (Format: `G-XXXXXXXXXX`)

### API Secret erstellen
1. Scrollen Sie nach unten zu **Measurement Protocol API secrets**
2. Klicken Sie auf **Erstellen**
3. Name: `WordPress Server-Side Tracking` (oder beliebig)
4. Klicken Sie auf **Erstellen**
5. Kopieren Sie den **Secret-Wert** (Sie sehen ihn nur einmal!)

## Schritt 3: Plugin konfigurieren

1. Gehen Sie in WordPress zu **Einstellungen** → **GA4 SST**
2. Fügen Sie die **Measurement ID** ein
3. Fügen Sie das **API Secret** ein
4. Aktivieren Sie **Tracking aktivieren**
5. Klicken Sie auf **Einstellungen speichern**

## Schritt 4: Überprüfung

### Status überprüfen
- Der Status-Bereich auf der Einstellungsseite sollte grüne Häkchen zeigen

### Logs überprüfen
1. Besuchen Sie eine Seite Ihrer Website
2. Gehen Sie zu **Einstellungen** → **GA4 Logs**
3. Sie sollten jetzt Einträge sehen

### GA4 Echtzeit-Bericht
1. Öffnen Sie Google Analytics
2. Gehen Sie zu **Berichte** → **Echtzeit**
3. Besuchen Sie Ihre Website
4. Sie sollten die Aktivität in Echtzeit sehen

## Fehlerbehebung

### Keine Daten in GA4?
- Überprüfen Sie die Measurement ID (Format: `G-XXXXXXXXXX`)
- Überprüfen Sie das API Secret (keine Leerzeichen)
- Schauen Sie in **Einstellungen** → **GA4 Logs** nach Fehlern
- Aktivieren Sie WordPress Debug-Modus für detaillierte Fehler

### WordPress Debug aktivieren
```php
// In wp-config.php
define('WP_DEBUG', true);
define('WP_DEBUG_LOG', true);
```

Dann Logs prüfen in `/wp-content/debug.log`

## Erweiterte Konfiguration

### Custom Events senden
```php
if (function_exists('wp_ga4_sst')) {
    $tracker = wp_ga4_sst()->tracker;
    if ($tracker) {
        $tracker->track_event('custom_event', array(
            'param1' => 'value1',
            'param2' => 'value2'
        ));
    }
}
```

### Logs-Aufbewahrung anpassen
Die Logs werden standardmäßig nach 30 Tagen gelöscht. 
Um dies zu ändern, bearbeiten Sie in `includes/class-wp-ga4-sst-tracker.php`:

```php
// Zeile ~237
$wpdb->query(
    $wpdb->prepare(
        "DELETE FROM $table_name WHERE day < DATE_SUB(CURDATE(), INTERVAL %d DAY)",
        30  // <- Hier die Anzahl der Tage ändern
    )
);
```

## Support

For issues:
- Visit: [https://wp-ga4-sst.seo-day.de](https://wp-ga4-sst.seo-day.de)
- Email: info@seo-day.de
- Create a [GitHub Issue](https://github.com/seo-day/wp-ga4-sst/issues)
- Check [README.md](README.md) for more information

## About

**SEO-DAY GmbH**
- Developer: Fabian Rossbacher (CEO)
- Address: Adolf-Kaschny-Straße 19, 51373 Leverkusen, Germany
- Email: info@seo-day.de
- Website: https://seo-day.de

