# WP GA4 Server-Side Tracking

Ein WordPress-Plugin für server-seitiges Google Analytics 4 (GA4) Tracking mittels Measurement Protocol API.

## Beschreibung

Dieses Plugin ermöglicht es, Google Analytics 4 Daten direkt vom Server zu senden, ohne JavaScript im Browser des Besuchers auszuführen. Das bietet mehrere Vorteile:

- **Datenschutz**: Keine Client-seitige Datenerfassung
- **Ad-Blocker**: Umgeht Ad-Blocker, die JavaScript-basiertes Tracking blockieren
- **Performance**: Keine zusätzlichen JavaScript-Dateien im Frontend
- **Zuverlässigkeit**: Server-seitige Datenerfassung ist zuverlässiger

## Features

✅ Server-side GA4 Tracking via Measurement Protocol  
✅ **4 Event Types**: `page_view`, `first_visit`, `session_start`, `user_engagement`  
✅ **Smart Cookie Management**: `technical_website_cookie` for user identification  
✅ **Session Tracking**: 30-minute session timeout with automatic detection  
✅ Automatic Client ID Management  
✅ User Role Tracking  
✅ Easy Configuration in WordPress Admin  
✅ Status Dashboard  
✅ **Call Logging to Database**: All GA4 calls saved in `wp_ga4_sst_calls` with `response_code`  
✅ **Logs Overview**: Admin page to view all saved calls with filtering  
✅ **Automatic Cleanup**: Logs older than 30 days are automatically deleted  

## Installation

### Manuelle Installation

1. Laden Sie das Plugin-Verzeichnis in `/wp-content/plugins/` hoch
2. Aktivieren Sie das Plugin über das 'Plugins' Menü in WordPress
3. Gehen Sie zu Einstellungen → GA4 SST
4. Konfigurieren Sie Ihre Measurement ID und API Secret

### Via Git

```bash
cd wp-content/plugins/
git clone https://github.com/yourusername/wp-ga4-sst.git
```

## Konfiguration

### 1. GA4 Measurement ID und API Secret erhalten

1. Öffnen Sie Ihr [Google Analytics 4 Property](https://analytics.google.com/)
2. Gehen Sie zu **Admin** → **Datenströme**
3. Wählen Sie Ihren **Web-Datenstrom** aus
4. Kopieren Sie die **Measurement ID** (Format: `G-XXXXXXXXXX`)
5. Scrollen Sie nach unten zu **Measurement Protocol API secrets**
6. Klicken Sie auf **Erstellen**
7. Geben Sie einen Namen ein (z.B. "WordPress Server-Side Tracking")
8. Kopieren Sie den **Secret-Wert**

### 2. Plugin konfigurieren

1. Gehen Sie in WordPress zu **Einstellungen** → **GA4 SST**
2. Fügen Sie die **Measurement ID** ein
3. Fügen Sie das **API Secret** ein
4. Aktivieren Sie **Tracking aktivieren**
5. Klicken Sie auf **Einstellungen speichern**

## Verwendung

After activation, the plugin automatically tracks:

- **Page Views**: Every page visit is captured
- **First Visit**: Tracks when a user visits the site for the first time
- **Session Start**: Tracks when a new session begins
- **User Engagement**: User interactions are measured
- **User Properties**: User roles (for logged-in users)
- **Session Information**: Automatic session tracking

### Custom Events tracken (für Entwickler)

Sie können eigene Events programmatisch senden:

```php
// Event ohne Parameter
if (function_exists('wp_ga4_sst')) {
    $tracker = wp_ga4_sst()->tracker;
    if ($tracker) {
        $tracker->track_event('button_click');
    }
}

// Event mit Parametern
if (function_exists('wp_ga4_sst')) {
    $tracker = wp_ga4_sst()->tracker;
    if ($tracker) {
        $tracker->track_event('purchase', array(
            'transaction_id' => '12345',
            'value' => 99.99,
            'currency' => 'EUR'
        ));
    }
}
```

### Call-Logs einsehen

Das Plugin speichert jeden GA4-Call in der Datenbank. Um die Logs einzusehen:

1. Gehen Sie zu **Einstellungen** → **GA4 Logs**
2. Hier sehen Sie eine Übersicht aller gesendeten Calls mit:
   - Timestamp
   - Tag
   - Domain
   - Request-Daten (JSON)
   - Response-Daten (JSON)
3. Sie können nach Tag filtern
4. Logs werden automatisch nach 30 Tagen gelöscht

**Datenbanktabelle:** `wp_ga4_sst_calls`

## Architektur

### Clean Code Prinzipien

Das Plugin folgt strikten Clean Code Prinzipien:

- **Model-Klassen** (`/models/`): Alle Datenobjekte als typisierte Klassen (keine assoziativen Arrays)
- **Repository-Klassen** (`/repositories/`): Ausschließlicher Datenbankzugriff über Repositories
- **Template-Trennung** (`/templates/`): HTML ohne Inline-CSS, **keine PHP-HTML-Vermischung**
- **CSS-Variablen** (`/css/colors.css`): Zentrale Farbdefinitionen
- **Strikte Trennung**: Kein PHP-Code in HTML-Templates außer Ausgabe-Logik

### Verzeichnisstruktur

```
wp-ga4-sst/
├── models/                          # Datenobjekte
│   ├── class-wp-ga4-sst-call-log.php
│   ├── class-wp-ga4-sst-event.php
│   ├── class-wp-ga4-sst-event-params.php
│   ├── class-wp-ga4-sst-settings.php
│   └── class-wp-ga4-sst-log-statistics.php
│
├── repositories/                    # Datenbankzugriffe
│   └── class-wp-ga4-sst-call-log-repository.php
│
├── includes/                        # Business-Logik
│   ├── class-wp-ga4-sst-tracker.php
│   ├── class-wp-ga4-sst-admin.php
│   └── class-wp-ga4-sst-logs.php
│
├── templates/                       # HTML-Templates (keine PHP-HTML-Vermischung)
│   ├── admin-settings.php          # Haupt-Settings-Seite
│   ├── admin-logs.php              # Logs-Übersicht
│   ├── status-table.php            # Status-Tabelle
│   ├── section-info.php            # Sektion-Info
│   ├── field-enabled.php           # Enabled-Feld
│   ├── field-measurement-id.php    # Measurement-ID-Feld
│   └── field-api-secret.php        # API-Secret-Feld
│
├── css/                            # CSS-Dateien
│   ├── colors.css                  # Farbvariablen
│   ├── admin.css                   # Admin-Styles
│   └── logs.css                    # Logs-Styles
│
└── languages/                      # Übersetzungen
```

## Technische Details

### Tracked Events

#### page_view
- `page_location`: Current URL
- `page_title`: Page title
- `page_referrer`: Referrer
- `language`: Language
- `user_agent`: Browser User Agent

#### first_visit
- `page_location`: Current URL
- Triggered only on the very first visit

#### session_start
- `page_location`: Current URL
- `session_id`: Session identifier
- Triggered at the beginning of each new session (30 min timeout)

#### user_engagement
- `engagement_time_msec`: Engagement time
- `page_location`: Current URL

### Privacy & Cookies

The plugin:
- Generates an anonymous Client ID via cookie (`technical_website_cookie`)
  - Permanent cookie (10 years validity)
  - Used to identify unique users and first visits
- Session cookie (`technical_website_session`)
  - 30 minutes timeout
  - Used to detect new sessions
- Does not store personal data locally
- Sends data directly to Google Analytics
- Uses User IDs only for logged-in users (optional)

### Model-Klassen

#### WP_GA4_SST_Call_Log
Repräsentiert einen GA4 API Call mit allen relevanten Daten.

#### WP_GA4_SST_Event
Repräsentiert ein GA4 Event mit Name und Parametern.

#### WP_GA4_SST_Event_Params
Kapselt Event-Parameter mit Factory-Methoden für Standard-Events.

#### WP_GA4_SST_Settings
Verwaltet Plugin-Einstellungen (Measurement ID, API Secret, Status).

#### WP_GA4_SST_Log_Statistics
Hält Log-Statistiken (Anzahl Calls, Tage, Domains).

### Repository-Klassen

#### WP_GA4_SST_Call_Log_Repository
Zentraler Datenbankzugriff für Call Logs:
- `save()`: Call Log speichern
- `get_all()`: Logs mit Pagination abrufen
- `count()`: Anzahl Logs ermitteln
- `get_statistics()`: Statistiken abrufen
- `delete_older_than()`: Alte Logs löschen
- `create_table()`: Tabelle erstellen
- `drop_table()`: Tabelle löschen

### Datenbanktabelle

Das Plugin erstellt die Tabelle `wp_ga4_sst_calls` mit folgenden Feldern:

- `id` (bigint): Primärschlüssel
- `timestamp` (datetime): Zeitstempel des Calls
- `day` (date): Tag des Calls (für Filterung)
- `domain` (varchar): Domain, von der der Call gesendet wurde
- `request` (longtext): JSON-Daten des Requests
- `response` (longtext): JSON-Daten der Response

**Automatische Bereinigung:** Einträge älter als 30 Tage werden automatisch gelöscht.

### Performance

- Verwendet blocking HTTP Requests für zuverlässiges Logging
- 5 Sekunden Timeout für API-Anfragen
- Minimaler Performance-Impact auf die Website
- Automatische Datenbank-Bereinigung verhindert unbegrenztes Wachstum

## Systemanforderungen

- WordPress 5.0 oder höher
- PHP 7.4 oder höher
- Aktive Google Analytics 4 Property mit Measurement Protocol API

## Häufig gestellte Fragen (FAQ)

### Werden Ad-Blocker umgangen?

Ja, da das Tracking server-seitig erfolgt, können Browser-basierte Ad-Blocker dies nicht blockieren.

### Ist das DSGVO-konform?

Das Plugin selbst ist datenschutzfreundlich gestaltet. Sie müssen jedoch trotzdem eine Datenschutzerklärung bereitstellen und ggf. eine Einwilligung für Google Analytics einholen, da Daten an Google übermittelt werden.

### Kann ich beide Tracking-Methoden (client-seitig und server-seitig) gleichzeitig nutzen?

Ja, aber achten Sie darauf, keine Doppel-Erfassungen zu verursachen. In den meisten Fällen sollte eine Methode ausreichen.

### Wo sehe ich die getrackte Daten?

Die Daten erscheinen in Ihrem Google Analytics 4 Dashboard unter Berichte → Echtzeit und in den Standard-Berichten.

## Support

For questions or issues:
- Visit: [https://wp-ga4-sst.seo-day.de](https://wp-ga4-sst.seo-day.de)
- Email: info@seo-day.de
- Create an [Issue on GitHub](https://github.com/seo-day/wp-ga4-sst/issues)

## Changelog

### 1.0.0 (2025-10-08)
- Initial release
- **4 Event Types**: `page_view`, `first_visit`, `session_start`, `user_engagement`
- **Cookie Management**:
  - `technical_website_cookie` for user identification (10 years)
  - `technical_website_session` for session tracking (30 min timeout)
- Admin configuration page
- Status dashboard
- Call logging to database table `wp_ga4_sst_calls` with `response_code` field
- Logs overview page with filtering
- Automatic cleanup of logs (30 days)
- **Clean Code Architecture:**
  - Model classes for all data objects (no associative arrays)
  - Repository pattern for database access
  - Template separation (HTML without inline CSS)
  - **No PHP-HTML mixing** - strict template usage
  - CSS variables for central color definitions
  - 8 dedicated templates for clean view logic
- **Fully English**: All UI, descriptions, and code comments in English

## Lizenz

GPL v2 or later

## Credits

**Developed by:**
- **Company**: SEO-DAY GmbH
- **Developer**: Fabian Rossbacher (CEO)
- **Address**: Adolf-Kaschny-Straße 19, 51373 Leverkusen, Germany
- **Email**: info@seo-day.de
- **Website**: [https://seo-day.de](https://seo-day.de)
- **Plugin Website**: [https://wp-ga4-sst.seo-day.de](https://wp-ga4-sst.seo-day.de)

## Links

- [Plugin Website](https://wp-ga4-sst.seo-day.de)
- [SEO-DAY GmbH](https://seo-day.de)
- [Google Analytics 4 Documentation](https://developers.google.com/analytics/devguides/collection/protocol/ga4)
- [Measurement Protocol API Reference](https://developers.google.com/analytics/devguides/collection/protocol/ga4/reference)

