<?php
/**
 * Logs-Anzeige Klasse
 */

if (!defined('ABSPATH')) {
    exit;
}

class WP_GA4_SST_Logs {
    
    /**
     * @var WP_GA4_SST_Call_Log_Repository
     */
    private $repository;
    
    /**
     * Constructor
     */
    public function __construct() {
        $this->repository = new WP_GA4_SST_Call_Log_Repository();
        add_action('admin_enqueue_scripts', array($this, 'enqueue_styles'));
    }
    
    /**
     * Styles load
     */
    public function enqueue_styles($hook) {
        if ($hook !== 'settings_page_wp-ga4-sst-logs') {
            return;
        }
        
        // First colors.css, then logs.css logs.css
        wp_enqueue_style('wp-ga4-sst-colors', WP_GA4_SST_PLUGIN_URL . 'css/colors.css', array(), WP_GA4_SST_VERSION);
        wp_enqueue_style('wp-ga4-sst-logs', WP_GA4_SST_PLUGIN_URL . 'css/logs.css', array('wp-ga4-sst-colors'), WP_GA4_SST_VERSION);
    }
    
    /**
     * Logs-Seite render
     */
    public function render_logs_page() {
        if (!current_user_can('manage_options')) {
            return;
        }
        
        // Handle delete logs action
        $delete_success = false;
        if (isset($_POST['delete_logs']) && check_admin_referer('wp_ga4_sst_delete_logs', 'wp_ga4_sst_delete_logs_nonce')) {
            $this->repository->delete_all();
            $delete_success = true;
        }
        
        // Pagination
        $items_per_page = 20;
        $current_page = isset($_GET['paged']) ? max(1, intval($_GET['paged'])) : 1;
        $offset = ($current_page - 1) * $items_per_page;
        
        // Filter
        $filter_day = isset($_GET['filter_day']) ? sanitize_text_field($_GET['filter_day']) : '';
        
        // Daten aus Repository get
        $total_items = $this->repository->count($filter_day ?: null);
        $logs = $this->repository->get_all($items_per_page, $offset, $filter_day ?: null);
        
        $total_pages = ceil($total_items / $items_per_page);
        
        // Statistiken get
        $stats = $this->repository->get_statistics();
        
        // Load template
        include WP_GA4_SST_PLUGIN_DIR . 'templates/admin-logs.php';
    }
    
    /**
     * JSON format
     */
    private function format_json($json_string) {
        $decoded = json_decode($json_string);
        if (json_last_error() === JSON_ERROR_NONE) {
            return json_encode($decoded, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
        }
        return $json_string;
    }
}

