<?php
/**
 * Model: GA4 Call Log
 * Represents einen einzelnen GA4 API Call
 */

if (!defined('ABSPATH')) {
    exit;
}

class WP_GA4_SST_Call_Log {
    
    /**
     * @var int|null
     */
    private $id;
    
    /**
     * @var string
     */
    private $timestamp;
    
    /**
     * @var string
     */
    private $day;
    
    /**
     * @var string
     */
    private $domain;
    
    /**
     * @var int
     */
    private $response_code;
    
    /**
     * @var string
     */
    private $request;
    
    /**
     * @var string
     */
    private $response;
    
    /**
     * Constructor
     */
    public function __construct(
        $timestamp,
        $day,
        $domain,
        $response_code,
        $request,
        $response,
        $id = null
    ) {
        $this->id = $id;
        $this->timestamp = $timestamp;
        $this->day = $day;
        $this->domain = $domain;
        $this->response_code = (int) $response_code;
        $this->request = $request;
        $this->response = $response;
    }
    
    /**
     * ID get
     */
    public function get_id() {
        return $this->id;
    }
    
    /**
     * Timestamp get
     */
    public function get_timestamp() {
        return $this->timestamp;
    }
    
    /**
     * Tag get
     */
    public function get_day() {
        return $this->day;
    }
    
    /**
     * Domain get
     */
    public function get_domain() {
        return $this->domain;
    }
    
    /**
     * Response Code get
     */
    public function get_response_code() {
        return $this->response_code;
    }
    
    /**
     * Request get
     */
    public function get_request() {
        return $this->request;
    }
    
    /**
     * Response get
     */
    public function get_response() {
        return $this->response;
    }
    
    /**
     * ID setzen (nach Insert)
     */
    public function set_id($id) {
        $this->id = $id;
    }
    
    /**
     * Erstellt instance aus Database Row-Objekt
     */
    public static function from_db_row($row) {
        if (!$row) {
            return null;
        }
        
        return new self(
            $row->timestamp,
            $row->day,
            $row->domain,
            $row->response_code,
            $row->request,
            $row->response,
            $row->id
        );
    }
    
    /**
     * Als Array für database access
     */
    public function to_db_array() {
        $data = array(
            'timestamp' => $this->timestamp,
            'day' => $this->day,
            'domain' => $this->domain,
            'response_code' => $this->response_code,
            'request' => $this->request,
            'response' => $this->response,
        );
        
        if ($this->id !== null) {
            $data['id'] = $this->id;
        }
        
        return $data;
    }
}

