<?php
/**
 * Model: GA4 Event Parameters
 * Represents Event Parameter
 */

if (!defined('ABSPATH')) {
    exit;
}

class WP_GA4_SST_Event_Params {
    
    /**
     * @var array
     */
    private $params;
    
    /**
     * Constructor
     */
    public function __construct($params = array()) {
        $this->params = $params;
    }
    
    /**
     * Parameter add
     */
    public function add_param($key, $value) {
        $this->params[$key] = $value;
    }
    
    /**
     * Parameter get
     */
    public function get_param($key) {
        return isset($this->params[$key]) ? $this->params[$key] : null;
    }
    
    /**
     * All Parameter get
     */
    public function to_array() {
        return $this->params;
    }
    
    /**
     * Page View Parameter create
     */
    public static function create_page_view($page_location, $page_title, $page_referrer = '', $language = '') {
        $params = new self();
        $params->add_param('page_location', $page_location);
        $params->add_param('page_title', $page_title);
        $params->add_param('engagement_time_msec', 1); // Required for GA4 to show in reports
        
        if ($page_referrer) {
            $params->add_param('page_referrer', $page_referrer);
        }
        
        if ($language) {
            $params->add_param('language', $language);
        }
        
        return $params;
    }
    
    /**
     * User Engagement Parameter create
     */
    public static function create_user_engagement($engagement_time_msec, $page_location) {
        $params = new self();
        $params->add_param('engagement_time_msec', $engagement_time_msec);
        $params->add_param('page_location', $page_location);
        return $params;
    }
}

