<?php
/**
 * Model: GA4 Event
 * Represents ein GA4 Event
 */

if (!defined('ABSPATH')) {
    exit;
}

class WP_GA4_SST_Event {
    
    /**
     * @var string
     */
    private $name;
    
    /**
     * @var WP_GA4_SST_Event_Params
     */
    private $params;
    
    /**
     * Constructor
     */
    public function __construct($name, WP_GA4_SST_Event_Params $params) {
        $this->name = $name;
        $this->params = $params;
    }
    
    /**
     * Event Name get
     */
    public function get_name() {
        return $this->name;
    }
    
    /**
     * Event Parameter get
     */
    public function get_params() {
        return $this->params;
    }
    
    /**
     * Als Array für API-Call
     */
    public function to_array() {
        return array(
            'name' => $this->name,
            'params' => $this->params->to_array()
        );
    }
}

