<?php
/**
 * Model: Log Statistics
 * Represents Log-Statistiken
 */

if (!defined('ABSPATH')) {
    exit;
}

class WP_GA4_SST_Log_Statistics {
    
    /**
     * @var int
     */
    private $total_calls;
    
    /**
     * @var int
     */
    private $total_days;
    
    /**
     * @var int
     */
    private $total_domains;
    
    /**
     * Constructor
     */
    public function __construct($total_calls, $total_days, $total_domains) {
        $this->total_calls = (int) $total_calls;
        $this->total_days = (int) $total_days;
        $this->total_domains = (int) $total_domains;
    }
    
    /**
     * Gesamtanzahl Calls get
     */
    public function get_total_calls() {
        return $this->total_calls;
    }
    
    /**
     * Number of days mit Aktivität get
     */
    public function get_total_days() {
        return $this->total_days;
    }
    
    /**
     * Count Domains get
     */
    public function get_total_domains() {
        return $this->total_domains;
    }
    
    /**
     * Aus Database Row create
     */
    public static function from_db_row($row) {
        if (!$row) {
            return new self(0, 0, 0);
        }
        
        return new self(
            $row->total_calls,
            $row->total_days,
            $row->total_domains
        );
    }
}

