<?php
/**
 * Model: GA4 Settings
 * Represents Plugin-Einstellungen
 */

if (!defined('ABSPATH')) {
    exit;
}

class WP_GA4_SST_Settings {
    
    /**
     * @var bool
     */
    private $enabled;
    
    /**
     * @var string
     */
    private $measurement_id;
    
    /**
     * @var string
     */
    private $api_secret;
    
    /**
     * Constructor
     */
    public function __construct($enabled, $measurement_id, $api_secret) {
        $this->enabled = $enabled;
        $this->measurement_id = $measurement_id;
        $this->api_secret = $api_secret;
    }
    
    /**
     * Ist Tracking aktiviert?
     */
    public function is_enabled() {
        return $this->enabled;
    }
    
    /**
     * Measurement ID get
     */
    public function get_measurement_id() {
        return $this->measurement_id;
    }
    
    /**
     * API Secret get
     */
    public function get_api_secret() {
        return $this->api_secret;
    }
    
    /**
     * Sind die Credentials vollständig?
     */
    public function has_credentials() {
        return !empty($this->measurement_id) && !empty($this->api_secret);
    }
    
    /**
     * Ist vollständig konfiguriert?
     */
    public function is_configured() {
        return $this->enabled && $this->has_credentials();
    }
    
    /**
     * Aus WordPress-Optionen load
     */
    public static function load_from_options() {
        return new self(
            (bool) get_option('wp_ga4_sst_enabled', false),
            get_option('wp_ga4_sst_measurement_id', ''),
            get_option('wp_ga4_sst_api_secret', '')
        );
    }
}

