<?php
/**
 * Template: Admin Logs Page
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <?php if ($delete_success): ?>
        <div class="notice notice-success is-dismissible">
            <p><?php esc_html_e('All logs have been deleted successfully.', 'seoday-wp-ga4-sst'); ?></p>
        </div>
    <?php endif; ?>
    
    <!-- Statistiken -->
    <div class="wp-ga4-sst-stats">
        <div class="stat-box">
            <div class="stat-number"><?php echo number_format_i18n($stats->get_total_calls()); ?></div>
            <div class="stat-label"><?php esc_html_e('Total Calls', 'seoday-wp-ga4-sst'); ?></div>
        </div>
        <div class="stat-box">
            <div class="stat-number"><?php echo number_format_i18n($stats->get_total_days()); ?></div>
            <div class="stat-label"><?php esc_html_e('Days with Activity', 'seoday-wp-ga4-sst'); ?></div>
        </div>
        <div class="stat-box">
            <div class="stat-number"><?php echo number_format_i18n($stats->get_total_domains()); ?></div>
            <div class="stat-label"><?php esc_html_e('Domains', 'seoday-wp-ga4-sst'); ?></div>
        </div>
    </div>
    
    <!-- Filter and Actions -->
    <div class="wp-ga4-sst-actions">
        <form method="get" class="wp-ga4-sst-filter">
            <input type="hidden" name="page" value="wp-ga4-sst-logs">
            <label for="filter_day"><?php esc_html_e('Filter by day:', 'seoday-wp-ga4-sst'); ?></label>
            <input type="date" name="filter_day" id="filter_day" value="<?php echo esc_attr($filter_day); ?>">
            <button type="submit" class="button"><?php esc_html_e('Filter', 'seoday-wp-ga4-sst'); ?></button>
            <?php if ($filter_day): ?>
                <a href="<?php echo admin_url('admin.php?page=wp-ga4-sst-logs'); ?>" class="button">
                    <?php esc_html_e('Reset Filter', 'seoday-wp-ga4-sst'); ?>
                </a>
            <?php endif; ?>
        </form>
        
        <form method="post" class="wp-ga4-sst-delete" onsubmit="return confirm('<?php esc_attr_e('Are you sure you want to delete all logs? This action cannot be undone.', 'seoday-wp-ga4-sst'); ?>');">
            <?php wp_nonce_field('wp_ga4_sst_delete_logs', 'wp_ga4_sst_delete_logs_nonce'); ?>
            <button type="submit" name="delete_logs" class="button button-secondary">
                <?php esc_html_e('Delete All Logs', 'seoday-wp-ga4-sst'); ?>
            </button>
        </form>
    </div>
    
    <!-- Logs-table -->
    <table class="wp-list-table widefat fixed striped">
        <thead>
            <tr>
                <th class="col-id"><?php esc_html_e('ID', 'seoday-wp-ga4-sst'); ?></th>
                <th class="col-timestamp"><?php esc_html_e('Timestamp', 'seoday-wp-ga4-sst'); ?></th>
                <th class="col-day"><?php esc_html_e('Day', 'seoday-wp-ga4-sst'); ?></th>
                <th class="col-domain"><?php esc_html_e('Domain', 'seoday-wp-ga4-sst'); ?></th>
                <th class="col-response-code"><?php esc_html_e('Status', 'seoday-wp-ga4-sst'); ?></th>
                <th class="col-request"><?php esc_html_e('Request', 'seoday-wp-ga4-sst'); ?></th>
                <th class="col-response"><?php esc_html_e('Response', 'seoday-wp-ga4-sst'); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($logs)): ?>
                <tr>
                    <td colspan="7" class="no-logs">
                        <?php esc_html_e('No logs found.', 'seoday-wp-ga4-sst'); ?>
                    </td>
                </tr>
            <?php else: ?>
                <?php foreach ($logs as $log): ?>
                    <tr>
                        <td><?php echo esc_html($log->get_id()); ?></td>
                        <td><?php echo esc_html($log->get_timestamp()); ?></td>
                        <td><?php echo esc_html($log->get_day()); ?></td>
                        <td><?php echo esc_html($log->get_domain()); ?></td>
                        <td>
                            <?php 
                            $code = $log->get_response_code();
                            $class = $code >= 200 && $code < 300 ? 'status-success' : ($code >= 400 ? 'status-error' : 'status-info');
                            ?>
                            <span class="response-code <?php echo esc_attr($class); ?>">
                                <?php echo esc_html($code); ?>
                            </span>
                        </td>
                        <td>
                            <details>
                                <summary><?php esc_html_e('Show', 'seoday-wp-ga4-sst'); ?></summary>
                                <pre class="code-block"><?php echo esc_html($this->format_json($log->get_request())); ?></pre>
                                <button type="button" class="button copy-btn" data-copy="<?php echo esc_attr($this->format_json($log->get_request())); ?>">
                                    <?php esc_html_e('Copy', 'seoday-wp-ga4-sst'); ?>
                                </button>
                            </details>
                        </td>
                        <td>
                            <details>
                                <summary><?php esc_html_e('Show', 'seoday-wp-ga4-sst'); ?></summary>
                                <pre class="code-block"><?php echo esc_html($this->format_json($log->get_response())); ?></pre>
                                <button type="button" class="button copy-btn" data-copy="<?php echo esc_attr($this->format_json($log->get_response())); ?>">
                                    <?php esc_html_e('Copy', 'seoday-wp-ga4-sst'); ?>
                                </button>
                            </details>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
    
    <!-- Pagination -->
    <?php if ($total_pages > 1): ?>
        <div class="tablenav bottom">
            <div class="tablenav-pages">
                <?php
                echo paginate_links(array(
                    'base' => add_query_arg('paged', '%#%'),
                    'format' => '',
                    'prev_text' => __('&laquo;'),
                    'next_text' => __('&raquo;'),
                    'total' => $total_pages,
                    'current' => $current_page
                ));
                ?>
            </div>
        </div>
    <?php endif; ?>
    
    <!-- Hinweis -->
    <p class="description">
        <?php esc_html_e('Logs are automatically deleted after 30 days.', 'seoday-wp-ga4-sst'); ?>
    </p>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const copyButtons = document.querySelectorAll('.copy-btn');
    
    copyButtons.forEach(function(button) {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            const textToCopy = this.getAttribute('data-copy');
            
            // Copy to clipboard using Clipboard API
            if (navigator.clipboard && navigator.clipboard.writeText) {
                navigator.clipboard.writeText(textToCopy).then(function() {
                    // No notification as requested
                }).catch(function(err) {
                    // Fallback for older browsers
                    fallbackCopy(textToCopy);
                });
            } else {
                // Fallback for older browsers
                fallbackCopy(textToCopy);
            }
        });
    });
    
    function fallbackCopy(text) {
        const textarea = document.createElement('textarea');
        textarea.value = text;
        textarea.style.position = 'fixed';
        textarea.style.opacity = '0';
        document.body.appendChild(textarea);
        textarea.select();
        document.execCommand('copy');
        document.body.removeChild(textarea);
    }
});
</script>

