<?php
/**
 * Template: Admin Settings Page
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <div class="notice notice-info">
        <p>
            <strong><?php esc_html_e('Server-Side GA4 Tracking', 'seoday-wp-ga4-sst'); ?></strong><br>
            <?php esc_html_e('This plugin sends analytics data directly from your server to Google Analytics 4, without executing JavaScript in the visitor\'s browser.', 'seoday-wp-ga4-sst'); ?>
        </p>
    </div>
    
    <form action="options.php" method="post">
        <?php
        settings_fields('wp_ga4_sst_settings');
        do_settings_sections('seoday-wp-ga4-sst');
        submit_button(__('Save Settings', 'seoday-wp-ga4-sst'));
        ?>
    </form>
    
    <hr>
    
    <div class="card">
        <h2><?php esc_html_e('Status', 'seoday-wp-ga4-sst'); ?></h2>
        <?php echo $status_table; ?>
    </div>
    
    <div class="card">
        <h2><?php esc_html_e('Instructions', 'seoday-wp-ga4-sst'); ?></h2>
        <ol>
            <li><?php esc_html_e('Open your Google Analytics 4 property', 'seoday-wp-ga4-sst'); ?></li>
            <li><?php esc_html_e('Go to Admin > Data Streams', 'seoday-wp-ga4-sst'); ?></li>
            <li><?php esc_html_e('Select your web data stream', 'seoday-wp-ga4-sst'); ?></li>
            <li><?php esc_html_e('Copy the Measurement ID (e.g. G-XXXXXXXXXX)', 'seoday-wp-ga4-sst'); ?></li>
            <li><?php esc_html_e('Scroll down to "Measurement Protocol API secrets"', 'seoday-wp-ga4-sst'); ?></li>
            <li><?php esc_html_e('Create a new secret and copy the value', 'seoday-wp-ga4-sst'); ?></li>
            <li><?php esc_html_e('Enter both values in the fields above', 'seoday-wp-ga4-sst'); ?></li>
            <li><?php esc_html_e('Enable tracking and save', 'seoday-wp-ga4-sst'); ?></li>
        </ol>
    </div>
</div>

