<?php
/**
 * Template: Enabled Field
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<label>
    <input type="checkbox" 
           name="wp_ga4_sst_enabled" 
           value="1" 
           <?php checked($enabled, true); ?>
           <?php echo $can_activate ? '' : 'disabled'; ?>>
    <?php esc_html_e('Activate', 'seoday-wp-ga4-sst'); ?>
</label>
<?php if (!$can_activate): ?>
<p class="description" style="color: #d63638;">
    <?php esc_html_e('Please set both Measurement ID and API Secret before activating.', 'seoday-wp-ga4-sst'); ?>
</p>
<?php else: ?>
<p class="description">
    <?php esc_html_e('Enable this option to use server-side GA4 tracking.', 'seoday-wp-ga4-sst'); ?>
</p>
<?php endif; ?>

