<?php
/**
 * Template: Status Table
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<table class="widefat">
    <tbody>
        <!-- Tracking Status -->
        <tr>
            <td><strong><?php esc_html_e('Tracking Status', 'seoday-wp-ga4-sst'); ?></strong></td>
            <?php if ($enabled && $measurement_id && $api_secret): ?>
                <td>
                    <span class="dashicons dashicons-yes-alt status-active"></span>
                    <?php esc_html_e('Active', 'seoday-wp-ga4-sst'); ?>
                </td>
            <?php elseif ($enabled): ?>
                <td>
                    <span class="dashicons dashicons-warning status-warning"></span>
                    <?php esc_html_e('Enabled, but credentials missing', 'seoday-wp-ga4-sst'); ?>
                </td>
            <?php else: ?>
                <td>
                    <span class="dashicons dashicons-dismiss status-inactive"></span>
                    <?php esc_html_e('Disabled', 'seoday-wp-ga4-sst'); ?>
                </td>
            <?php endif; ?>
        </tr>
        
        <!-- Measurement ID Status -->
        <tr>
            <td><strong><?php esc_html_e('Measurement ID', 'seoday-wp-ga4-sst'); ?></strong></td>
            <?php if ($measurement_id): ?>
                <td>
                    <span class="dashicons dashicons-yes-alt status-active"></span>
                    <?php esc_html_e('Configured', 'seoday-wp-ga4-sst'); ?>
                </td>
            <?php else: ?>
                <td>
                    <span class="dashicons dashicons-dismiss status-inactive"></span>
                    <?php esc_html_e('Not configured', 'seoday-wp-ga4-sst'); ?>
                </td>
            <?php endif; ?>
        </tr>
        
        <!-- API Secret Status -->
        <tr>
            <td><strong><?php esc_html_e('API Secret', 'seoday-wp-ga4-sst'); ?></strong></td>
            <?php if ($api_secret): ?>
                <td>
                    <span class="dashicons dashicons-yes-alt status-active"></span>
                    <?php esc_html_e('Configured', 'seoday-wp-ga4-sst'); ?>
                </td>
            <?php else: ?>
                <td>
                    <span class="dashicons dashicons-dismiss status-inactive"></span>
                    <?php esc_html_e('Not configured', 'seoday-wp-ga4-sst'); ?>
                </td>
            <?php endif; ?>
        </tr>
    </tbody>
</table>

