<?php
/**
 * Uninstall Script
 * 
 * Wird ausgeführt, wenn das Plugin deinstalliert wird.
 */

// Verhindere direkten Zugriff
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Repository load
require_once plugin_dir_path(__FILE__) . 'repositories/class-wp-ga4-sst-call-log-repository.php';

// Plugin-Optionen delete
delete_option('wp_ga4_sst_enabled');
delete_option('wp_ga4_sst_measurement_id');
delete_option('wp_ga4_sst_api_secret');

// Datenbanktabelle delete
$repository = new WP_GA4_SST_Call_Log_Repository();
$repository->drop_table();

// Für Multisite
if (is_multisite()) {
    global $wpdb;
    $blog_ids = $wpdb->get_col("SELECT blog_id FROM $wpdb->blogs");
    
    foreach ($blog_ids as $blog_id) {
        switch_to_blog($blog_id);
        
        delete_option('wp_ga4_sst_enabled');
        delete_option('wp_ga4_sst_measurement_id');
        delete_option('wp_ga4_sst_api_secret');
        
        // Datenbanktabelle delete
        $repository = new WP_GA4_SST_Call_Log_Repository();
        $repository->drop_table();
        
        restore_current_blog();
    }
}

// Hinweis: Client ID Cookies werden nicht gelöscht, da diese im Browser des Nutzers liegen

