<?php
/**
 * Plugin Name: SEODAY-WP-GA4-SST
 * Plugin URI: https://wp-ga4-sst.seo-day.de
 * Description: Server-side Google Analytics 4 tracking for WordPress using Measurement Protocol API
 * Version: 2.2.1
 * Author: SEO-DAY GmbH
 * Author URI: https://seo-day.de
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: seoday-wp-ga4-sst
 * Domain Path: /languages
 * 
 * Developer: Fabian Rossbacher
 * Company: SEO-DAY GmbH
 * Address: Adolf-Kaschny-Straße 19, 51373 Leverkusen, Germany
 * Email: info@seo-day.de
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Plugin constants
define('WP_GA4_SST_VERSION', '2.2.1');
define('WP_GA4_SST_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('WP_GA4_SST_PLUGIN_URL', plugin_dir_url(__FILE__));

// Autoloader - Models
require_once WP_GA4_SST_PLUGIN_DIR . 'models/class-wp-ga4-sst-call-log.php';
require_once WP_GA4_SST_PLUGIN_DIR . 'models/class-wp-ga4-sst-event-params.php';
require_once WP_GA4_SST_PLUGIN_DIR . 'models/class-wp-ga4-sst-event.php';
require_once WP_GA4_SST_PLUGIN_DIR . 'models/class-wp-ga4-sst-settings.php';
require_once WP_GA4_SST_PLUGIN_DIR . 'models/class-wp-ga4-sst-log-statistics.php';

// Autoloader - Repositories
require_once WP_GA4_SST_PLUGIN_DIR . 'repositories/class-wp-ga4-sst-call-log-repository.php';

// Autoloader - Includes
require_once WP_GA4_SST_PLUGIN_DIR . 'includes/class-wp-ga4-sst-tracker.php';
require_once WP_GA4_SST_PLUGIN_DIR . 'includes/class-wp-ga4-sst-admin.php';
require_once WP_GA4_SST_PLUGIN_DIR . 'includes/class-wp-ga4-sst-logs.php';

/**
 * Main plugin class
 */
class WP_GA4_SST {
    
    /**
     * Singleton instance
     */
    private static $instance = null;
    
    /**
     * Tracker instance
     */
    private $tracker;
    
    /**
     * Admin instance
     */
    private $admin;
    
    /**
     * Logs instance
     */
    private $logs;
    
    /**
     * Singleton pattern
     */
    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    /**
     * Constructor
     */
    private function __construct() {
        $this->init();
    }
    
    /**
     * Initialize plugin
     */
    private function init() {
        // Initialize admin area
        if (is_admin()) {
            $this->admin = new WP_GA4_SST_Admin();
            $this->logs = new WP_GA4_SST_Logs();
        }
        
        // Initialize tracker (only if enabled)
        if (get_option('wp_ga4_sst_enabled', false)) {
            $this->tracker = new WP_GA4_SST_Tracker();
        }
        
        // Register hooks
        register_activation_hook(__FILE__, array($this, 'activate'));
        register_deactivation_hook(__FILE__, array($this, 'deactivate'));
    }
    
    /**
     * Plugin activation
     */
    public function activate() {
        // Set default options
        if (get_option('wp_ga4_sst_enabled') === false) {
            update_option('wp_ga4_sst_enabled', false);
        }
        
        // Create database table
        $this->create_database_table();
    }
    
    /**
     * Create database table
     */
    private function create_database_table() {
        $repository = new WP_GA4_SST_Call_Log_Repository();
        $repository->create_table();
    }
    
    /**
     * Plugin deactivation
     */
    public function deactivate() {
        // Cleanup if needed
    }
}

// Initialize plugin
function wp_ga4_sst() {
    return WP_GA4_SST::get_instance();
}

// Start plugin
wp_ga4_sst();

